/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.data;

public class Parameter {
    private String key;
    private String value;
    private ParaType type;

    public Parameter() {
        this.key = "";
        this.value = "";
        this.type = ParaType.STRING;
    }

    public Parameter(String i, String v, ParaType t) {
        this.key = i;
        this.value = v;
        this.type = t;
    }

    public Parameter(String i, String v) {
        this.key = i;
        this.value = v;
        this.type = ParaType.STRING;
    }

    public Parameter(String i, boolean v) {
        this.key = i;
        this.value = new Boolean(v).toString();
        this.type = ParaType.BOOLEAN;
    }

    public Parameter(String i, int v) {
        this.key = i;
        this.value = Integer.toString(v);
        this.type = ParaType.INTEGER;
    }

    public void setValue(String v) {
        this.value = v;
        this.type = ParaType.STRING;
    }

    public void setValue(boolean v) {
        this.value = new Boolean(v).toString();
        this.type = ParaType.BOOLEAN;
    }

    public void setValue(int v) {
        this.value = Integer.toString(v);
        this.type = ParaType.INTEGER;
    }

    public void setKey(String v) {
        this.key = v;
    }

    public String getKey() {
        return this.key;
    }

    public String getString() {
        return this.value;
    }

    public String getStringValue() {
        return this.value;
    }

    public int getIntegerValue() {
        return Integer.parseInt(this.value);
    }

    public boolean getBooleanValue() {
        return Boolean.valueOf(this.value);
    }

    public ParaType getType() {
        return this.type;
    }

    public static enum ParaType {
        STRING,
        BOOLEAN,
        INTEGER;

    }
}

