/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server;

import ch.uyuno.printcontrol.data.Parameter;
import ch.uyuno.printcontrol.server.MachineAccess;

public class Utilities {
    private static String getKey(byte[] buf) {
        String result = "";
        if (buf.length > 3) {
            result = String.valueOf(result) + Integer.toHexString(0x100 | buf[1]).substring(1);
            result = String.valueOf(result) + Integer.toHexString(0x100 | buf[2]).substring(1);
            result = String.valueOf(result) + Integer.toHexString(0x100 | buf[3]).substring(1);
        }
        return result;
    }

    private static byte getType(byte[] buf) {
        byte result = 0;
        if (buf.length > 4) {
            result = buf[4];
        }
        return result;
    }

    private static boolean getBooleanValue(byte[] buf) {
        boolean result = false;
        if (buf.length > 5 && buf[5] != 0) {
            result = true;
        }
        return result;
    }

    private static int getIntegerValue(byte[] buf) {
        int result = 0;
        if (buf.length > 8) {
            result = 0xFF & buf[8];
            result |= 0xFF00 & buf[7] << 8;
            result |= 0xFF0000 & buf[6] << 16;
            result |= 0xFF000000 & buf[5] << 24;
        }
        return result;
    }

    private static String getStringValue(byte[] buf) {
        String result = "";
        int strSize = 0;
        if (buf.length > 5) {
            strSize = buf.length - 5;
            byte[] buf1 = new byte[strSize];
            int i = 0;
            while (i < strSize) {
                buf1[i] = buf[i + 5];
                ++i;
            }
            result = new String(buf1);
        }
        return result;
    }

    public static Parameter convertByteArrayToParameter(byte[] buf) {
        Parameter result = null;
        String key = Utilities.getKey(buf);
        switch (Utilities.getType(buf)) {
            case 1: {
                result = new Parameter(key, Utilities.getIntegerValue(buf));
                break;
            }
            case 2: {
                result = new Parameter(key, Utilities.getBooleanValue(buf));
                break;
            }
            case 3: {
                result = new Parameter(key, Utilities.getStringValue(buf));
            }
        }
        return result;
    }

    private static boolean setKey(String key, byte[] buf) {
        boolean result = false;
        if (buf.length > 3 && key.length() >= 6) {
            int temp = Integer.valueOf(key.substring(0, 2), 16);
            buf[1] = (byte)temp;
            temp = Integer.valueOf(key.substring(2, 4), 16);
            buf[2] = (byte)temp;
            temp = Integer.valueOf(key.substring(4, 6), 16);
            buf[3] = (byte)temp;
            result = true;
        }
        return result;
    }

    private static boolean setType(byte type, byte[] buf) {
        boolean result = false;
        if (buf.length > 4) {
            buf[4] = type;
            result = true;
        }
        return result;
    }

    private static boolean setBooleanValue(boolean value, byte[] buf) {
        boolean result = false;
        if (buf.length >= 5) {
            buf[5] = 0;
            if (value) {
                buf[5] = 1;
            }
            result = true;
        }
        return result;
    }

    private static boolean setIntegerValue(int value, byte[] buf) {
        boolean result = false;
        if (buf.length > 8) {
            buf[8] = (byte)value;
            buf[7] = (byte)Integer.rotateRight(value, 8);
            buf[6] = (byte)Integer.rotateRight(value, 16);
            buf[5] = (byte)Integer.rotateRight(value, 24);
            result = true;
        }
        return result;
    }

    private static boolean setStringValue(String value, byte[] buf) {
        boolean result = false;
        if (buf.length > 4 + value.length()) {
            int i = 0;
            while (i < value.length()) {
                buf[i + 5] = (byte)value.charAt(i);
                ++i;
            }
            result = true;
        }
        return result;
    }

    public static byte[] convertParameterToByteArray(byte cmd, Parameter p) {
        byte[] result = null;
        if (p.getType() == Parameter.ParaType.INTEGER) {
            result = new byte[9];
            result[0] = cmd;
            Utilities.setKey(p.getKey(), result);
            Utilities.setType((byte)1, result);
            Utilities.setIntegerValue(p.getIntegerValue(), result);
        } else if (p.getType() == Parameter.ParaType.BOOLEAN) {
            result = new byte[6];
            result[0] = cmd;
            Utilities.setKey(p.getKey(), result);
            Utilities.setType((byte)2, result);
            boolean tempBool = p.getBooleanValue();
            Utilities.setBooleanValue(tempBool, result);
        } else if (p.getType() == Parameter.ParaType.STRING) {
            result = new byte[5 + p.getStringValue().length()];
            result[0] = cmd;
            Utilities.setKey(p.getKey(), result);
            Utilities.setType((byte)3, result);
            Utilities.setStringValue(p.getStringValue(), result);
        }
        return result;
    }

    public static MachineAccess.STATE convertByteToState(byte state) {
        MachineAccess.STATE result = MachineAccess.STATE.INIT;
        if (state == 4) {
            result = MachineAccess.STATE.STOP;
        } else if (state == 5 || state == 6) {
            result = MachineAccess.STATE.RUN;
        } else if (state == 8 || state == 6) {
            result = MachineAccess.STATE.EMERGENCY_STOP;
        } else if (state == 7) {
            result = MachineAccess.STATE.ERROR;
        }
        return result;
    }

    public static Parameter convertBlockByteArrayToParameter(byte[] buf, byte index) {
        Parameter result = null;
        byte[] tempBuf = new byte[4];
        byte[] tempBuf2 = null;
        if (buf.length > 3) {
            tempBuf[1] = buf[1];
            tempBuf[2] = buf[2];
            tempBuf[3] = index;
            String key = Utilities.getKey(tempBuf);
            boolean notfound = false;
            int ParameterCounter = 0;
            int bufIndex = 3;
            block15: while (tempBuf2 == null && !notfound) {
                if (bufIndex < buf.length) {
                    int i;
                    if (ParameterCounter < index) {
                        switch (buf[bufIndex]) {
                            case 1: {
                                bufIndex += 5;
                                break;
                            }
                            case 2: {
                                bufIndex += 2;
                                break;
                            }
                            case 3: {
                                ++bufIndex;
                                i = 0;
                                while (buf[bufIndex] != 0 && i < 20) {
                                    ++i;
                                    ++bufIndex;
                                }
                                ++bufIndex;
                                break;
                            }
                            default: {
                                notfound = true;
                            }
                        }
                        ++ParameterCounter;
                        continue;
                    }
                    switch (buf[bufIndex]) {
                        case 1: {
                            tempBuf2 = new byte[9];
                            tempBuf2[4] = buf[bufIndex];
                            tempBuf2[5] = buf[bufIndex + 1];
                            tempBuf2[6] = buf[bufIndex + 2];
                            tempBuf2[7] = buf[bufIndex + 3];
                            tempBuf2[8] = buf[bufIndex + 4];
                            break;
                        }
                        case 2: {
                            tempBuf2 = new byte[6];
                            tempBuf2[4] = buf[bufIndex];
                            tempBuf2[5] = buf[bufIndex + 1];
                            break;
                        }
                        case 3: {
                            i = 1;
                            while (buf[bufIndex + i] != 0 && i < 21) {
                                ++i;
                            }
                            tempBuf2 = new byte[5 + --i];
                            while (i >= 0) {
                                tempBuf2[4 + i] = buf[bufIndex + i];
                                --i;
                            }
                            continue block15;
                        }
                        default: {
                            notfound = true;
                            break;
                        }
                    }
                    continue;
                }
                notfound = true;
            }
            if (tempBuf2 != null) {
                switch (Utilities.getType(tempBuf2)) {
                    case 1: {
                        result = new Parameter(key, Utilities.getIntegerValue(tempBuf2));
                        break;
                    }
                    case 2: {
                        result = new Parameter(key, Utilities.getBooleanValue(tempBuf2));
                        break;
                    }
                    case 3: {
                        result = new Parameter(key, Utilities.getStringValue(tempBuf2));
                    }
                }
            }
        }
        return result;
    }

    public static enum CommunicationERROR {
        NONE,
        IN_USE,
        INIT,
        NO_SUCH_PORT,
        NO_SUCH_HOST;

    }
}

