/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server;

import ch.uyuno.printcontrol.server.CommunicationManager;
import ch.uyuno.printcontrol.server.ComunicationObject;
import ch.uyuno.printcontrol.server.IMachineControlListener;
import ch.uyuno.printcontrol.server.MachineAccess;
import ch.uyuno.printcontrol.server.Messages;
import ch.uyuno.printcontrol.server.Utilities;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class MachineControl
implements Runnable {
    public static final int MAX_MACHINES = 10;
    private static MachineControl singelton = null;
    private boolean scanRunning = false;
    private boolean stateUpdateRunning = false;
    private CommunicationManager m;
    private List<MachineAccess> machines = new Vector<MachineAccess>();
    private STATE state;
    private Set<IMachineControlListener> Listeners = new HashSet<IMachineControlListener>();
    private int MaxMachine = 1;

    public static MachineControl getMachineMainControl() {
        if (singelton == null) {
            singelton = new MachineControl();
        }
        return singelton;
    }

    private MachineControl() {
        this.m = CommunicationManager.getManager();
        this.machines.clear();
        this.state = STATE.STOP;
        new Thread((Runnable)this, "MachineControl").start();
    }

    private void changeState(STATE state) {
        this.state = state;
        Iterator<IMachineControlListener> iterator = this.Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().changeState(this.state);
        }
    }

    private void searchProgress(int percent, String text, boolean error) {
        Iterator<IMachineControlListener> iterator = this.Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().searchProgress(percent, text, error);
        }
    }

    public void removeChangeListener(IMachineControlListener viewer) {
        this.Listeners.remove(viewer);
    }

    public void addChangeListener(IMachineControlListener viewer) {
        this.Listeners.add(viewer);
    }

    @Override
    public void run() {
        int NbrOfMachines = 0;
        int ActiveMachineIndex = 0;
        byte[] buffer1 = new byte[]{1};
        try {
            while (true) {
                if (!this.scanRunning) {
                    Thread.sleep(100L);
                    continue;
                }
                this.changeState(STATE.SEARCH);
                this.searchProgress(0, Messages.getString("MachineControl.TryToOpenThePort"), false);
                this.machines.clear();
                this.m.openPort();
                while (!this.m.isPortOpen() && this.m.getError() == Utilities.CommunicationERROR.NONE) {
                    Thread.sleep(100L);
                }
                Thread.sleep(500L);
                if (this.m.isPortOpen()) {
                    MachineAccess ma;
                    byte[] buffer2;
                    this.MaxMachine = this.m.getMaxMachine();
                    if (this.MaxMachine > 10) {
                        this.MaxMachine = 10;
                    }
                    ComunicationObject co = new ComunicationObject(1);
                    co.setRequest(buffer1, buffer1.length);
                    int i = 1;
                    while (i <= this.MaxMachine) {
                        this.searchProgress(i * 100 / this.MaxMachine, String.valueOf(Messages.getString("MachineControl.SearchMaschineId")) + i, false);
                        co.setAddres((byte)i);
                        co.Prozess();
                        buffer2 = co.getAnser();
                        if (buffer2 != null && buffer2.length >= 5 && co.getAnserAddres() == i) {
                            ma = new MachineAccess(co.clone());
                            ma.setComVersion(buffer2[2]);
                            ma.setFamilyType(buffer2[3]);
                            ma.setSubType(buffer2[4]);
                            if (buffer2.length >= 7) {
                                ma.setMaxNbrOfApplication(buffer2[5] * 256 | buffer2[6] & 0xFF);
                            } else {
                                ma.setMaxNbrOfApplication(100);
                            }
                            this.machines.add(ma);
                        }
                        ++i;
                    }
                    this.scanRunning = false;
                    NbrOfMachines = this.machines.size();
                    if (NbrOfMachines > 0) {
                        Iterator<MachineAccess> iterator;
                        this.changeState(STATE.RUN);
                        ActiveMachineIndex = 0;
                        this.stateUpdateRunning = true;
                        while (this.stateUpdateRunning && this.m.isPortOpen()) {
                            ma = this.machines.get(ActiveMachineIndex);
                            co = ma.getNewComunicationOpject();
                            co.setRequest(buffer1, buffer1.length);
                            co.Prozess();
                            buffer2 = co.getAnser();
                            if (buffer2 != null) {
                                if (buffer2.length >= 5) {
                                    ma.setState(Utilities.convertByteToState(buffer2[1]));
                                }
                            } else {
                                ma.setState(MachineAccess.STATE.NO_COMMUNICATION);
                            }
                            if (++ActiveMachineIndex >= NbrOfMachines) {
                                ActiveMachineIndex = 0;
                            }
                            this.changeState(STATE.RUN);
                            Thread.sleep(2000L);
                        }
                        this.changeState(STATE.STOPPING);
                        while (this.isTransferRunning()) {
                            iterator = this.machines.iterator();
                            while (iterator.hasNext()) {
                                if (!iterator.next().isTransferRunning()) continue;
                                iterator.next().abortTransfer();
                            }
                            Thread.sleep(100L);
                        }
                        iterator = this.machines.iterator();
                        while (iterator.hasNext()) {
                            iterator.next().setState(MachineAccess.STATE.EXIT);
                        }
                    }
                    this.m.closePort();
                } else {
                    this.scanRunning = false;
                    if (this.m.getError() == Utilities.CommunicationERROR.IN_USE) {
                        this.searchProgress(100, Messages.getString("MachineControl.PortIsUsed"), true);
                    } else if (this.m.getError() == Utilities.CommunicationERROR.INIT) {
                        this.searchProgress(100, Messages.getString("MachineControl.PortInitFaild"), true);
                    } else if (this.m.getError() == Utilities.CommunicationERROR.NO_SUCH_PORT) {
                        this.searchProgress(100, Messages.getString("MachineControl.DidNotFindPort"), true);
                    } else if (this.m.getError() == Utilities.CommunicationERROR.NO_SUCH_HOST) {
                        this.searchProgress(100, Messages.getString("MachineControl.DidNotFindHost"), true);
                    } else {
                        this.searchProgress(100, Messages.getString("MachineControl.CanNotOpenPort"), true);
                    }
                    Thread.sleep(3000L);
                }
                this.changeState(STATE.STOP);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public void StartWork() {
        this.scanRunning = true;
        this.stateUpdateRunning = false;
    }

    public boolean StopWork(boolean force) {
        boolean result = false;
        if (!this.isTransferRunning() || force) {
            this.scanRunning = false;
            this.stateUpdateRunning = false;
            result = true;
        }
        return result;
    }

    public boolean isWoking() {
        return this.stateUpdateRunning || this.scanRunning;
    }

    public boolean isTransferRunning() {
        boolean result = false;
        Iterator<MachineAccess> iterator = this.machines.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isTransferRunning()) continue;
            result = true;
        }
        return result;
    }

    public MachineAccess GetMachineAccess(int i) {
        MachineAccess ma = null;
        if (!this.scanRunning && this.machines.size() > i) {
            ma = this.machines.get(i);
        }
        return ma;
    }

    public int GetMachineAccessSize() {
        int result = 0;
        if (!this.scanRunning) {
            result = this.machines.size();
        }
        return result;
    }

    public static enum STATE {
        STOP,
        SEARCH,
        RUN,
        STOPPING;

    }
}

