/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.serialinterface;

import ch.uyuno.serialinterface.IDebugBufferChange;
import ch.uyuno.serialinterface.SerialDebugBuffer;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SerialDebugBufferList {
    private final int MAX_BUFFER_SIZE = 25;
    private Vector<SerialDebugBuffer> buffers = new Vector(25);
    private Set<IDebugBufferChange> changeListeners = new HashSet<IDebugBufferChange>();
    private boolean sending = false;
    private char[] buffer = new char[16];
    private int bufferindex = 0;
    Calendar calendar;

    private void addDebugBuffer(SerialDebugBuffer debug) {
        if (this.buffers.size() >= 25) {
            this.buffers.remove(0);
        }
        this.buffers.add(this.buffers.size(), debug);
    }

    public void DataIn(byte[] buf, int size) {
        boolean changed = false;
        if (this.sending) {
            if (this.bufferindex > 0) {
                this.addDebugBuffer(new SerialDebugBuffer((char[])this.buffer.clone(), this.bufferindex, false, this.calendar));
                changed = true;
            }
            this.bufferindex = 0;
            this.sending = false;
            this.calendar = Calendar.getInstance();
        } else if (this.bufferindex == 0) {
            this.calendar = Calendar.getInstance();
        }
        int i = 0;
        while (size > i) {
            this.buffer[this.bufferindex] = (char)buf[i];
            ++this.bufferindex;
            if (this.bufferindex > 15) {
                this.addDebugBuffer(new SerialDebugBuffer((char[])this.buffer.clone(), this.bufferindex, true, this.calendar));
                this.bufferindex = 0;
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.BufferChanged();
        }
    }

    public void DataOut(byte[] buf, int size) {
        boolean changed = false;
        if (!this.sending) {
            if (this.bufferindex > 0) {
                this.addDebugBuffer(new SerialDebugBuffer((char[])this.buffer.clone(), this.bufferindex, true, this.calendar));
                changed = true;
            }
            this.bufferindex = 0;
            this.sending = true;
            this.calendar = Calendar.getInstance();
        } else if (this.bufferindex == 0) {
            this.calendar = Calendar.getInstance();
        }
        int i = 0;
        while (size > i) {
            this.buffer[this.bufferindex] = (char)buf[i];
            ++this.bufferindex;
            if (this.bufferindex > 15) {
                this.addDebugBuffer(new SerialDebugBuffer((char[])this.buffer.clone(), this.bufferindex, false, this.calendar));
                this.bufferindex = 0;
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.BufferChanged();
        }
    }

    public Vector<SerialDebugBuffer> getBuffers() {
        return this.buffers;
    }

    public void BufferChanged() {
        Iterator<IDebugBufferChange> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().changed();
        }
    }

    public void removeChangeListener(IDebugBufferChange viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IDebugBufferChange viewer) {
        this.changeListeners.add(viewer);
    }
}

