/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.serialinterface;

public class Framing {
    byte[] mpReceiveBuffer = null;
    int mReceiveLength = 0;
    int mReceiveCount = 0;
    FramingStateType mReceiveState;
    byte[] mpTransmitBuffer = null;
    int mTransmitLength = 0;
    int mTransmitCount = 0;
    FramingStateType mTransmitState = FramingStateType.FRAMING_NONE;
    int mStartChar = -1;
    int mStopChar = -1;
    int mFlagChar = -1;
    int mEscChar = -1;
    int mReceiveChecksum = 0;
    int mTransmitChecksum = 0;
    int mChecksumDigits = 0;
    int mTransmitChecksumDigits = 0;

    public Framing() {
        this.mReceiveState = FramingStateType.FRAMING_NONE;
    }

    public void SetStartChar(byte Start) {
        this.mStartChar = Start;
    }

    public void ClearStartChar() {
        this.mStartChar = -1;
    }

    public void SetStopChar(byte Stop) {
        this.mStopChar = Stop;
    }

    public void ClearStopChar() {
        this.mStopChar = -1;
    }

    public void SetCharStuf(byte Flag, byte Esc) {
        this.mFlagChar = Flag;
        this.mEscChar = Esc;
    }

    public void ClearCharStuf() {
        this.mFlagChar = -1;
        this.mEscChar = -1;
    }

    public void SetChecksum(int Digits) {
        this.mChecksumDigits = Digits;
    }

    boolean ChecksumTest(boolean Binary) {
        if (this.mChecksumDigits > 0) {
            if (this.mChecksumDigits < this.mReceiveCount) {
                int Checksum = 0;
                int ChecksumMaximum = 1;
                int i = this.mReceiveCount - 1;
                while (i >= this.mReceiveCount - this.mChecksumDigits) {
                    this.mReceiveChecksum -= 0xFF & this.mpReceiveBuffer[i];
                    if (Binary) {
                        ChecksumMaximum *= 256;
                        Checksum *= 256;
                        Checksum += 0xFF & this.mpReceiveBuffer[i];
                    } else {
                        ChecksumMaximum *= 10;
                        Checksum *= 10;
                        Checksum += this.mpReceiveBuffer[i] - 48;
                    }
                    --i;
                }
                this.mReceiveChecksum %= ChecksumMaximum;
                return Checksum == this.mReceiveChecksum;
            }
            return false;
        }
        return true;
    }

    public void InitTransmit(byte[] Frame2, int Length) {
        this.mpTransmitBuffer = Frame2;
        this.mTransmitLength = Length;
        this.mTransmitCount = 0;
        this.mTransmitChecksum = 0;
        this.mTransmitChecksumDigits = 0;
        this.mTransmitState = this.mFlagChar >= 0 ? FramingStateType.FRAMING_FLAG_OPEN : (this.mStartChar >= 0 && this.mStopChar >= 0 ? FramingStateType.FRAMING_START : (this.mStopChar >= 0 ? FramingStateType.FRAMING_DATA : FramingStateType.FRAMING_NONE));
    }

    public int ToTransmit(byte[] Buffer, int Length) {
        int l = 0;
        while (l < Length && this.mTransmitState != FramingStateType.FRAMING_END) {
            switch (this.mTransmitState) {
                case FRAMING_NONE: {
                    if (this.mTransmitCount < this.mTransmitLength) {
                        Buffer[l] = this.mpTransmitBuffer[this.mTransmitCount];
                        ++this.mTransmitCount;
                        ++l;
                        break;
                    }
                    this.mTransmitState = FramingStateType.FRAMING_END;
                    break;
                }
                case FRAMING_START: {
                    Buffer[l++] = (byte)this.mStartChar;
                    this.mTransmitChecksum = 0;
                    this.mTransmitState = FramingStateType.FRAMING_DATA;
                    break;
                }
                case FRAMING_FLAG_OPEN: {
                    Buffer[l++] = (byte)this.mFlagChar;
                    this.mTransmitChecksum = 0;
                    this.mTransmitState = FramingStateType.FRAMING_FLAG_DATA;
                    break;
                }
                case FRAMING_DATA: {
                    if (this.mTransmitCount < this.mTransmitLength) {
                        Buffer[l] = this.mpTransmitBuffer[this.mTransmitCount];
                        this.mTransmitChecksum += 0xFF & Buffer[l];
                        ++this.mTransmitCount;
                        ++l;
                        break;
                    }
                    this.mTransmitChecksumDigits = 0;
                    this.mTransmitState = FramingStateType.FRAMING_STOP;
                    break;
                }
                case FRAMING_FLAG_DATA: {
                    if (this.mTransmitCount < this.mTransmitLength) {
                        if (this.mpTransmitBuffer[this.mTransmitCount] == this.mFlagChar || this.mpTransmitBuffer[this.mTransmitCount] == this.mEscChar) {
                            Buffer[l] = (byte)this.mEscChar;
                            ++l;
                            this.mTransmitState = FramingStateType.FRAMING_FLAG_ESC;
                            break;
                        }
                        Buffer[l] = this.mpTransmitBuffer[this.mTransmitCount];
                        this.mTransmitChecksum += 0xFF & Buffer[l];
                        ++this.mTransmitCount;
                        ++l;
                        break;
                    }
                    this.mTransmitChecksumDigits = 0;
                    this.mTransmitState = FramingStateType.FRAMING_FLAG_CLOSE;
                    break;
                }
                case FRAMING_FLAG_ESC: {
                    Buffer[l] = this.mpTransmitBuffer[this.mTransmitCount];
                    this.mTransmitChecksum += 0xFF & Buffer[l];
                    ++this.mTransmitCount;
                    ++l;
                    this.mTransmitState = FramingStateType.FRAMING_FLAG_DATA;
                    break;
                }
                case FRAMING_STOP: {
                    if (this.mTransmitChecksumDigits < this.mChecksumDigits) {
                        Buffer[l++] = (byte)(48 + this.mTransmitChecksum % 10);
                        this.mTransmitChecksum /= 10;
                        ++this.mTransmitChecksumDigits;
                        break;
                    }
                    if (this.mStopChar > 0) {
                        Buffer[l++] = (byte)this.mStopChar;
                    }
                    this.mTransmitState = FramingStateType.FRAMING_END;
                    break;
                }
                case FRAMING_FLAG_CLOSE: {
                    if (this.mTransmitChecksumDigits < this.mChecksumDigits) {
                        if (this.mTransmitChecksum % 256 == this.mEscChar || this.mTransmitChecksum % 256 == this.mFlagChar) {
                            Buffer[l] = (byte)this.mEscChar;
                            ++l;
                            this.mTransmitState = FramingStateType.FRAMING_FLAG_CLOSE_ESC;
                            break;
                        }
                        Buffer[l++] = (byte)(this.mTransmitChecksum % 256);
                        this.mTransmitChecksum /= 256;
                        ++this.mTransmitChecksumDigits;
                        break;
                    }
                    Buffer[l++] = (byte)this.mFlagChar;
                    this.mTransmitState = FramingStateType.FRAMING_END;
                    break;
                }
                case FRAMING_FLAG_CLOSE_ESC: {
                    Buffer[l++] = (byte)(this.mTransmitChecksum % 256);
                    this.mTransmitChecksum /= 256;
                    ++this.mTransmitChecksumDigits;
                    this.mTransmitState = FramingStateType.FRAMING_FLAG_CLOSE;
                    break;
                }
            }
        }
        return l;
    }

    public void InitReceive(byte[] Buffer, int Length) {
        this.mpReceiveBuffer = Buffer;
        this.mReceiveLength = Length;
        this.mReceiveCount = 0;
        this.mReceiveChecksum = 0;
        this.mReceiveState = this.mFlagChar >= 0 ? FramingStateType.FRAMING_FLAG_OPEN : (this.mStartChar >= 0 && this.mStopChar >= 0 ? FramingStateType.FRAMING_START : (this.mStopChar >= 0 ? FramingStateType.FRAMING_DATA : FramingStateType.FRAMING_NONE));
    }

    public int FromReceive(byte[] Buffer, int Length) {
        int l = 0;
        while (l < Length && this.mReceiveState != FramingStateType.FRAMING_END) {
            switch (this.mReceiveState) {
                case FRAMING_NONE: {
                    this.mpReceiveBuffer[this.mReceiveCount] = Buffer[l];
                    this.mReceiveChecksum += 0xFF & Buffer[l];
                    ++this.mReceiveCount;
                    ++l;
                    break;
                }
                case FRAMING_START: {
                    if (this.mStartChar == Buffer[l++]) {
                        this.mReceiveState = FramingStateType.FRAMING_DATA;
                    }
                    this.mReceiveChecksum = 0;
                    break;
                }
                case FRAMING_FLAG_OPEN: {
                    if (this.mFlagChar == Buffer[l++]) {
                        this.mReceiveState = FramingStateType.FRAMING_FLAG_DATA;
                    }
                    this.mReceiveChecksum = 0;
                    break;
                }
                case FRAMING_DATA: {
                    if (this.mStopChar == Buffer[l]) {
                        ++l;
                        l = this.ChecksumTest(false) ? this.mReceiveCount - this.mChecksumDigits : -2;
                        this.mReceiveCount = 0;
                        this.mReceiveState = this.mStartChar >= 0 ? FramingStateType.FRAMING_START : FramingStateType.FRAMING_DATA;
                        return l;
                    }
                    if (this.mStartChar == Buffer[l]) {
                        this.mReceiveCount = 0;
                        ++l;
                        this.mReceiveState = FramingStateType.FRAMING_START;
                        return -1;
                    }
                    this.mpReceiveBuffer[this.mReceiveCount] = Buffer[l];
                    this.mReceiveChecksum += 0xFF & Buffer[l];
                    ++this.mReceiveCount;
                    ++l;
                    break;
                }
                case FRAMING_FLAG_DATA: {
                    if (this.mEscChar == Buffer[l]) {
                        ++l;
                        this.mReceiveState = FramingStateType.FRAMING_FLAG_ESC;
                        break;
                    }
                    if (this.mFlagChar == Buffer[l]) {
                        ++l;
                        l = this.ChecksumTest(true) ? this.mReceiveCount - this.mChecksumDigits : -2;
                        this.mReceiveCount = 0;
                        this.mReceiveState = FramingStateType.FRAMING_FLAG_OPEN;
                        return l;
                    }
                    this.mpReceiveBuffer[this.mReceiveCount] = Buffer[l];
                    this.mReceiveChecksum += 0xFF & Buffer[l];
                    ++this.mReceiveCount;
                    ++l;
                    break;
                }
                case FRAMING_FLAG_ESC: {
                    this.mpReceiveBuffer[this.mReceiveCount] = Buffer[l];
                    this.mReceiveChecksum += 0xFF & Buffer[l];
                    ++this.mReceiveCount;
                    ++l;
                    this.mReceiveState = FramingStateType.FRAMING_FLAG_DATA;
                    break;
                }
            }
        }
        if (this.mReceiveState == FramingStateType.FRAMING_NONE) {
            this.mReceiveCount = 0;
            Length = 0;
            return l;
        }
        Length = 0;
        return 0;
    }

    static enum FramingStateType {
        FRAMING_NONE,
        FRAMING_START,
        FRAMING_DATA,
        FRAMING_FLAG_OPEN,
        FRAMING_FLAG_ESC,
        FRAMING_FLAG_DATA,
        FRAMING_FLAG_CLOSE,
        FRAMING_FLAG_CLOSE_ESC,
        FRAMING_STOP,
        FRAMING_END;

    }
}

