/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.views;

import ch.uyuno.printcontrol.server.ApplicationEntry;
import ch.uyuno.printcontrol.server.DataAccess;
import ch.uyuno.printcontrol.server.IDataAccessListener;
import ch.uyuno.printcontrol.server.Messages;
import ch.uyuno.printcontrol.server.actions.DeleteApplicationAction;
import ch.uyuno.printcontrol.server.actions.RenameApplicationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FileApplicationListView
extends ViewPart {
    private DataAccess data;
    private Composite compositeConnection;
    private String fileName = Messages.getString("FileApplicationListView.UndefinedDateiName");
    private IDataAccessListener dataListener;
    private TableViewer applicationTableViewer = null;
    private final String APP_NR_COLUMN = "nr";
    private final String APP_NAME_COLUMN = "name";
    private final String APP_NBR_OF_PAR_COLUMN = "nbrOfParameter";
    private String[] columnNames = new String[]{"nr", "name", "nbrOfParameter"};

    public FileApplicationListView() {
        this.data = new DataAccess();
        this.dataListener = new IDataAccessListener(){

            @Override
            public void DataChanged() {
                if (FileApplicationListView.this.applicationTableViewer != null) {
                    FileApplicationListView.this.applicationTableViewer.refresh();
                }
            }
        };
        this.data.addDataChangeListener(this.dataListener);
    }

    protected void finalize() {
        if (this.data != null && this.dataListener != null) {
            this.data.removeDataChangeListener(this.dataListener);
        }
        this.data = null;
        this.dataListener = null;
    }

    public boolean setInput(String fileName) {
        boolean result = false;
        if (fileName != null && fileName.length() > 0) {
            this.fileName = fileName;
            this.data.readFromFile(this.fileName);
            result = true;
            this.setPartName(fileName);
        }
        return result;
    }

    public String GetFileName() {
        return this.fileName;
    }

    public void doSave() {
        this.data.writeToFile(this.fileName);
    }

    public void doSaveAs(String fileName) {
        this.setPartName(fileName);
        this.fileName = fileName;
        this.doSave();
    }

    public void createPartControl(Composite parent) {
        this.setPartName(this.fileName);
        this.compositeConnection = new Composite(parent, 0);
        this.createConnectionPage(this.compositeConnection);
        this.getSite().setSelectionProvider((ISelectionProvider)this.applicationTableViewer);
    }

    private void createConnectionPage(Composite parent) {
        parent.setLayout((Layout)new GridLayout(6, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 6, 5));
        this.createApplicationTable(composite);
    }

    private void createApplicationTable(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        int style = 101124;
        Table applicationTable = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        applicationTable.setLayoutData((Object)gridData);
        applicationTable.setLinesVisible(true);
        applicationTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(applicationTable, 0x1000000, 0);
        column.setText(Messages.getString("FileApplicationListView.Id"));
        column.setToolTipText(Messages.getString("FileApplicationListView.ApplicationId"));
        column.setWidth(40);
        column = new TableColumn(applicationTable, 16384, 1);
        column.setText(Messages.getString("FileApplicationListView.Name"));
        column.setToolTipText(Messages.getString("FileApplicationListView.ApplicationName"));
        column.setWidth(150);
        column = new TableColumn(applicationTable, 0x1000000, 2);
        column.setText(Messages.getString("FileApplicationListView.Count"));
        column.setToolTipText(Messages.getString("FileApplicationListView.NbrOfParameter"));
        column.setWidth(50);
        this.applicationTableViewer = new TableViewer(applicationTable);
        this.applicationTableViewer.setColumnProperties(this.columnNames);
        this.applicationTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.applicationTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.applicationTableViewer.setSorter((ViewerSorter)new NameSorter());
        this.applicationTableViewer.setInput((Object)this.data);
        DragSource ds = new DragSource((Control)this.applicationTableViewer.getTable(), 2);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                String xml = "";
                int id = Integer.valueOf(FileApplicationListView.this.applicationTableViewer.getTable().getSelection()[0].getText(0));
                if (FileApplicationListView.this.data != null) {
                    xml = FileApplicationListView.this.data.getApplicationAsXML(id);
                }
                event.data = xml;
            }
        });
        DropTarget dt = new DropTarget((Control)this.applicationTableViewer.getTable(), 2);
        dt.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                TableItem t = (TableItem)event.item;
                int id = Integer.valueOf(t.getText(0));
                String xml = (String)event.data;
                if (FileApplicationListView.this.data != null && xml != null && id > 0) {
                    if (FileApplicationListView.this.data.isApplicationValied(id)) {
                        if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("Confirm"), (String)Messages.getString("FileApplicationListView.ConfirmText"))) {
                            FileApplicationListView.this.data.setApplicationAsXML(id, xml);
                        }
                    } else {
                        FileApplicationListView.this.data.setApplicationAsXML(id, xml);
                    }
                }
                FileApplicationListView.this.applicationTableViewer.refresh();
            }
        });
        DeleteApplicationAction deleteAction = new DeleteApplicationAction(Messages.getString("FileApplicationListView.DeleteMenu"), this.data);
        this.applicationTableViewer.addSelectionChangedListener((ISelectionChangedListener)deleteAction);
        deleteAction.selectionChanged((IStructuredSelection)this.applicationTableViewer.getSelection());
        RenameApplicationAction renameAction = new RenameApplicationAction(Messages.getString("FileApplicationListView.RenameMenu"), this.data);
        this.applicationTableViewer.addSelectionChangedListener((ISelectionChangedListener)renameAction);
        renameAction.selectionChanged((IStructuredSelection)this.applicationTableViewer.getSelection());
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.add((IAction)deleteAction);
        contextMenuManager.add((IAction)renameAction);
        Menu contextMenu = contextMenuManager.createContextMenu((Control)this.applicationTableViewer.getTable());
        this.applicationTableViewer.getTable().setMenu(contextMenu);
    }

    public void setFocus() {
        this.applicationTableViewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            return ((ApplicationEntry)o1).getNr() - ((ApplicationEntry)o2).getNr();
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return FileApplicationListView.this.data.getApplicationNameArray();
        }
    }

    public class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            String result = "";
            ApplicationEntry entry = (ApplicationEntry)obj;
            switch (index) {
                case 0: {
                    result = "" + entry.getNr();
                    break;
                }
                case 1: {
                    result = entry.getName();
                    break;
                }
                case 2: {
                    result = "" + entry.getNbrOfParameter();
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

