/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.actions;

import ch.uyuno.printcontrol.server.ApplicationEntry;
import ch.uyuno.printcontrol.server.DataAccess;
import ch.uyuno.printcontrol.server.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class DeleteApplicationAction
extends BaseSelectionListenerAction {
    private DataAccess data = null;

    public DeleteApplicationAction(String text, DataAccess data) {
        super(text);
        this.data = data;
    }

    public final void run() {
        if (this.getStructuredSelection().getFirstElement() instanceof ApplicationEntry && this.data != null) {
            ApplicationEntry a = (ApplicationEntry)this.getStructuredSelection().getFirstElement();
            if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("Confirm"), (String)(String.valueOf(Messages.getString("DeleteApplicationAction.ConfirmText")) + "\n\n " + Messages.getString("DeleteApplicationAction.ID") + a.getNr() + "\n\n " + Messages.getString("DeleteApplicationAction.Name") + a.getName()))) {
                this.data.removeApplication(a.getNr());
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = super.updateSelection(selection);
        if (selection.getFirstElement() instanceof ApplicationEntry && this.data != null) {
            ApplicationEntry a = (ApplicationEntry)selection.getFirstElement();
            result = result && this.data.isApplicationValied(a.getNr());
        } else {
            result = false;
        }
        return result;
    }
}

