/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.actions;

import ch.uyuno.printcontrol.server.Activator;
import ch.uyuno.printcontrol.server.IMachineControlListener;
import ch.uyuno.printcontrol.server.MachineControl;
import ch.uyuno.printcontrol.server.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ConnectAction
implements IWorkbenchWindowActionDelegate {
    private MachineControl control = null;
    private IWorkbenchWindow window;
    private IMachineControlListener listener = null;
    private IAction action = null;

    public void dispose() {
        if (this.listener != null && this.control != null) {
            this.control.removeChangeListener(this.listener);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.control = MachineControl.getMachineMainControl();
        this.listener = new IMachineControlListener(){

            @Override
            public void changeState(MachineControl.STATE newState) {
                Display d = PlatformUI.getWorkbench().getDisplay();
                if (!d.isDisposed()) {
                    d.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ConnectAction.this.action != null) {
                                if (!ConnectAction.this.control.isWoking()) {
                                    ConnectAction.this.action.setImageDescriptor(Activator.getImageDescriptor("/icons/unconnect.gif"));
                                    ConnectAction.this.action.setText(Messages.getString("ConnectAction.Connect"));
                                } else {
                                    ConnectAction.this.action.setImageDescriptor(Activator.getImageDescriptor("/icons/connect.gif"));
                                    ConnectAction.this.action.setText(Messages.getString("ConnectAction.Disconnect"));
                                }
                            }
                        }
                    });
                }
            }

            @Override
            public void searchProgress(int percent, String text, boolean error) {
            }
        };
        this.control.addChangeListener(this.listener);
    }

    public void run(IAction action) {
        if (this.control != null) {
            if (this.control.isWoking()) {
                if (this.control.StopWork(false)) {
                    action.setImageDescriptor(Activator.getImageDescriptor("/icons/unconnect.gif"));
                    action.setText(Messages.getString("ConnectAction.Connect"));
                } else {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)Messages.getString("Error"), (String)Messages.getString("ConnectAction.TransferRunning"));
                }
            } else {
                this.control.StartWork();
                action.setImageDescriptor(Activator.getImageDescriptor("/icons/connect.gif"));
                action.setText(Messages.getString("ConnectAction.Disconnect"));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        if (!this.control.isWoking()) {
            action.setImageDescriptor(Activator.getImageDescriptor("/icons/unconnect.gif"));
            action.setText(Messages.getString("ConnectAction.Connect"));
        } else {
            action.setImageDescriptor(Activator.getImageDescriptor("/icons/connect.gif"));
            action.setText(Messages.getString("ConnectAction.Disconnect"));
        }
    }
}

