/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Mailbox<T> {
    private static final int MAXQUEUE = 20;
    private final Queue<T> produkte = new LinkedList<T>();
    private final Lock lock = new ReentrantLock();
    private final Condition nichtVoll = this.lock.newCondition();
    private final Condition nichtLeer = this.lock.newCondition();

    public void put(T elem) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.produkte.size() == 20) {
                this.nichtVoll.await();
            }
            this.produkte.add(elem);
            this.nichtLeer.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T get() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.produkte.size() == 0) {
                this.nichtLeer.await();
            }
            T elem = this.produkte.poll();
            this.nichtVoll.signalAll();
            T t = elem;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

